/***************************************************************************************
File       : BasicInterface.h
Description: Routines for test
Author     : Laurent REGNIER
History    : Creation 23-May-2000   
Copyright STMicroelectronics 2000
***************************************************************************************/

#ifndef _BASIC_INTERFACE_H
	#define _BASIC_INTERFACE_H

#ifdef __cplusplus
	extern "C" 
	{
#endif

#ifndef ST10FLASHER_API
	#define ST10FLASHER_API __declspec(dllimport) // To import flasher function
#endif

// Communication function
ST10FLASHER_API unsigned int PASCAL SetCom(char *PortName, unsigned int ComSpeed);
ST10FLASHER_API unsigned int PASCAL CloseCom(void);
ST10FLASHER_API unsigned int PASCAL ComIsKline(void);
ST10FLASHER_API unsigned int PASCAL SetComSpeed(char *portName, unsigned int ComSpeed);
ST10FLASHER_API unsigned int PASCAL CalibrateSpeed(char *PortName, unsigned int ComSpeed);
ST10FLASHER_API unsigned int PASCAL IsAvailableBaudRate(const double frequency, const unsigned int baudrate);

// Global functions
ST10FLASHER_API unsigned int PASCAL LoadFile(char *filename, unsigned long &size);
ST10FLASHER_API unsigned int PASCAL InitMonitor(char *target);
ST10FLASHER_API unsigned int PASCAL LoadExternalFlashMonitor(char *Monitor, char *target);
ST10FLASHER_API unsigned int PASCAL GetError(char *BufferForStatus);
ST10FLASHER_API unsigned int PASCAL EnablePort(unsigned short PortNb, unsigned short BitPosition, bool Val);
ST10FLASHER_API unsigned int PASCAL DisablePort(unsigned short PortNb, unsigned short BitPosition);

// Flash functions
ST10FLASHER_API unsigned int PASCAL ProgramFlash(void);
ST10FLASHER_API unsigned int PASCAL EraseFlash(unsigned int Block);
ST10FLASHER_API unsigned int PASCAL VerifyFlash(unsigned int Block);
ST10FLASHER_API void         PASCAL SetROMS1(unsigned int ROMS1);
ST10FLASHER_API unsigned int PASCAL AutoROMS1(bool& RomS1Set);
ST10FLASHER_API unsigned int PASCAL BlockNbToErase(bool ErrorToSet);
ST10FLASHER_API unsigned int PASCAL LockFlash(unsigned int MaskBlock);
ST10FLASHER_API unsigned int PASCAL GetHexFileBlock(unsigned short &Iter);

// Obsoletes functions - try to never use it
ST10FLASHER_API unsigned int PASCAL BlankCheck(void); // --> Replaced by GetBlankBank
ST10FLASHER_API unsigned int PASCAL Close(void); // --> Replaced by CloseCom
ST10FLASHER_API unsigned int PASCAL ProgramAndVerify(void);// --> Replaced by Program
ST10FLASHER_API unsigned int PASCAL TestCom(void);
ST10FLASHER_API unsigned int PASCAL DumpBlock(char *filename, unsigned int BlockNb);
ST10FLASHER_API unsigned int PASCAL DumpToScreenAddress(char *filename, unsigned int StartAddr, unsigned int Size, unsigned int format);
ST10FLASHER_API unsigned int PASCAL DumpAddress(char *filename, unsigned int StartAddr, unsigned int Size);
ST10FLASHER_API unsigned int PASCAL DumpOffset(char *filename, unsigned int BlockNb, unsigned int format, unsigned int Offset);
ST10FLASHER_API unsigned int PASCAL TestComSpeed(unsigned int *i, unsigned int *WrongData);

// New functions
ST10FLASHER_API unsigned int PASCAL GetNbBlock(void);
ST10FLASHER_API unsigned int PASCAL GetBlockMaskDescription(const unsigned int BlockMask, char *cBlock, const char *Header);
ST10FLASHER_API unsigned int PASCAL GetBlockDescription(const unsigned int BlockNb, char *cBlock);
ST10FLASHER_API unsigned int PASCAL GetST10FlasherVersion(char *cBlock);
ST10FLASHER_API unsigned int PASCAL GetBlankBank(unsigned int &BlanckBlockMask);
ST10FLASHER_API bool         PASCAL AdjustCpuFrequency(double& Frequency);
ST10FLASHER_API double       PASCAL GetCpuFrequency();
ST10FLASHER_API unsigned int PASCAL IsMonitorAlive(void);
ST10FLASHER_API unsigned int PASCAL DumpBlocks(char *filename, unsigned int BlockNb, unsigned int Option);
ST10FLASHER_API unsigned int PASCAL DumpRange(char *filename, unsigned int Start, unsigned int Size, unsigned int Option);
ST10FLASHER_API unsigned int PASCAL GetBlockRange (const unsigned int BlockNb , char * Description, unsigned int& Start , unsigned int& Size, unsigned int First );


#if 0  // For documentation
// Obsoletes functions - try to never use it
ST10FLASHER_API unsigned int PASCAL BlankCheck(void); // --> Replaced by GetBlankBank
ST10FLASHER_API unsigned int PASCAL Close(void);
ST10FLASHER_API unsigned int PASCAL ProgramAndVerify(void);// --> Replaced by Program
ST10FLASHER_API double       PASCAL AdjustFrequency(double frequency, int *DevError);//--> AdjustCpuFrequency
ST10FLASHER_API unsigned int PASCAL TestCom(void);
ST10FLASHER_API unsigned int PASCAL TestComSpeed(unsigned int *i, unsigned int *WrongData);
ST10FLASHER_API unsigned int PASCAL DumpToScreenAddress(char *filename, unsigned int StartAddr, unsigned int Size, unsigned int format); //--> Replaced by DumpBlocks 
ST10FLASHER_API unsigned int PASCAL DumpAddress(char *filename, unsigned int StartAddr, unsigned int Size); //--> Replaced by DumpBlocks 
ST10FLASHER_API unsigned int PASCAL DumpOffset(char *filename, unsigned int BlockNb, unsigned int format,  unsigned int Offset); //--> Replaced by DumpBlocks 

// New functions
ST10FLASHER_API unsigned int PASCAL GetNbBlock(void);
ST10FLASHER_API unsigned int PASCAL GetBlockDescription(const unsigned int BlockNb, char *cBlock);
ST10FLASHER_API unsigned int PASCAL GetBlockMaskDescription(const unsigned int BlockMask, char *cBlock, const char *Header);
ST10FLASHER_API unsigned int PASCAL GetST10FlasherVersion(char *cBlock);
ST10FLASHER_API unsigned int PASCAL GetBlankBank(unsigned int &BlanckBlockMask);
ST10FLASHER_API unsigned int PASCAL CloseCom(void);
ST10FLASHER_API unsigned int PASCAL IsAvailableBaudRate(const double frequency, unsigned int baudrate);
ST10FLASHER_API unsigned int PASCAL IsMonitorAlive(void);
ST10FLASHER_API unsigned int PASCAL DumpBlocks(char *filename, unsigned int BlockNb, unsigned int Option);
ST10FLASHER_API unsigned int PASCAL DumpRange(char *filename, unsigned int Start, unsigned int Size, unsigned int Option);
ST10FLASHER_API unsigned int PASCAL GetBlockRange (const unsigned int BlockNb , char * Description, unsigned int& Start , unsigned int& Size, unsigned int First );
ST10FLASHER_API unsigned int PASCAL Alignement(unsigned int& Addr, unsigned int Align, unsigned int ToUpper);

// Delete functions
ST10FLASHER_API unsigned int PASCAL CurrentDevice(void);
#endif


#ifdef __cplusplus
}
#endif

#endif